function exportWheel(wh, spreadsheet_name)

spreadsheet_name = spreadsheet_name + ".xlsx";

% Main data
mainData = table('Size', [0 3], ...
    'VariableTypes', ["string", "cell", "string"], ...
    'VariableNames', ["Main Parameters", "value", "unit"]);

mainData(end+1, :) = {"Full name", {wh.fullName}, ""};
mainData(end+1, :) = {"Moment of inertia", {wh.inertia}, "kg*m^2"};
mainData(end+1, :) = {"Radius", {wh.radius}, "m"};
mainData(end+1, :) = {"Mass", {wh.mass}, "kg"};


% Write to spreadsheet
writetable(mainData, spreadsheet_name, Sheet = "main")

end


